/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.CustomCardMaker.components;

import LegendaryCardMaker.CustomCardMaker.CustomCardMakerFrame;
import LegendaryCardMaker.CustomCardMaker.structure.ElementBackgroundImage;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class BackgroundImageMenuItem
extends JMenu
implements ActionListener {
    public ElementBackgroundImage property;
    public CustomCardMakerFrame frame;
    private Locale currentLocale = Locale.getDefault();
    private ResourceBundle labels = ResourceBundle.getBundle("LegendaryCardMaker.tools.language.LegendaryCardMakerMenu", this.currentLocale);

    public BackgroundImageMenuItem(CustomCardMakerFrame frame, ElementBackgroundImage property) {
        this.property = property;
        this.frame = frame;
        this.setText(property.name);
        this.addActionListener(this);
        JMenuItem setImagePath = new JMenuItem(this.labels.getString("SetImagePath"));
        setImagePath.setActionCommand("setImagePath");
        setImagePath.addActionListener(this);
        this.add(setImagePath);
        JMenuItem setImageZoom = new JMenuItem(this.labels.getString("SetImageZoom"));
        setImageZoom.setActionCommand("setImageZoom");
        setImageZoom.addActionListener(this);
        this.add(setImageZoom);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("setImagePath")) {
            JFileChooser chooser = new JFileChooser();
            FileNameExtensionFilter filter1 = new FileNameExtensionFilter("Image files", "png", "jpeg", "jpg", "bmp");
            chooser.addChoosableFileFilter(filter1);
            chooser.setFileFilter(filter1);
            int outcome = chooser.showOpenDialog(this.frame);
            if (outcome == 0) {
                try {
                    this.property.path = chooser.getSelectedFile().getAbsolutePath();
                    this.property.zoom = 1.0;
                    this.property.imageOffsetX = 0;
                    this.property.imageOffsetY = 0;
                    this.frame.reRenderCard();
                    this.frame.hm.card.changed = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (e.getActionCommand().equals("setImageZoom")) {
            String s = JOptionPane.showInputDialog(this.frame, this.labels.getString("SetImageZoom"), this.property.zoom);
            if (s == null) {
                s = "" + this.property.zoom;
            }
            if (s != null && s.isEmpty()) {
                s = "" + this.property.zoom;
            }
            try {
                this.property.zoom = Double.parseDouble(s);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage());
            }
            this.frame.setCursor(Cursor.getPredefinedCursor(3));
            this.frame.reRenderCard();
            this.frame.hm.card.changed = true;
            this.frame.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

